package gov.va.vinci.dart.dms.biz;

import gov.va.vinci.dart.service.DartObjectFactory;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

@Entity
@Table(name="attribute", schema="hib")
public class Attribute {

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	protected int id;

	@Version
	@Column(name="version")
	protected int version;  // for optimistic locking managed by Hibernate
	
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="documentid")
	Document document;
	
	@Column(name="key")
	private String key;

	@Column(name="value")
	private String value;

	public static Attribute create(final Document document, final String key, final String value) {
		Attribute result = new Attribute();
		result.document = document;
		result.key = key;
		result.value = value;
		
		DartObjectFactory.getInstance().getAttributeDAO().save(result);
		
		return result;
	}

	public static Attribute findById(final int id) {
		return DartObjectFactory.getInstance().getAttributeDAO().findById(id);
	}

	public void delete() {
		DartObjectFactory.getInstance().getAttributeDAO().delete(this);
	}
	
	public int getId() {
		return id;
	}

	// TESTING ONLY
	public void setId(int id) {
		this.id = id;
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}

	public void modify(final String value) {
		this.value = value;
	}
}
